% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble_weighted.R
\name{ensemble_weighted}
\alias{ensemble_weighted}
\title{Creates a Weighted Ensemble Model}
\usage{
ensemble_weighted(object, loadings, scale_loadings = TRUE)
}
\arguments{
\item{object}{A Modeltime Table}

\item{loadings}{A vector of weights corresponding to the loadings}

\item{scale_loadings}{If TRUE, divides by the sum of the loadings
to proportionally weight the submodels.}
}
\value{
A \code{mdl_time_ensemble} object.
}
\description{
Makes an ensemble by applying \code{loadings} to weight sub-model predictions
}
\details{
The input to an \code{ensemble_weighted()} model is always a Modeltime Table,
which contains the models that you will ensemble.

\strong{Weighting Method}

The weighted method uses uses \code{loadings} by applying a
\emph{loading x model prediction} for each submodel.
}
\examples{
\donttest{
library(tidymodels)
library(modeltime)
library(modeltime.ensemble)
library(tidyverse)
library(timetk)

# Make an ensemble from a Modeltime Table
ensemble_fit <- m750_models \%>\%
    ensemble_weighted(
        loadings = c(3, 3, 1),
        scale_loadings = TRUE
    )

ensemble_fit

# Forecast with the Ensemble
modeltime_table(
    ensemble_fit
) \%>\%
    modeltime_forecast(
        new_data    = testing(m750_splits),
        actual_data = m750
    ) \%>\%
    plot_modeltime_forecast(
        .interactive = FALSE,
        .conf_interval_show = FALSE
    )
}

}
