% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-py_datetime.R
\name{as_pandas_timestamp}
\alias{as_pandas_timestamp}
\title{Convert R Date or POSIXt to Pandas Timestamp}
\usage{
as_pandas_timestamp(x, ..., pass_time_zone = FALSE)
}
\arguments{
\item{x}{A Date or Date Time}

\item{...}{Additional parameters passed to Pandas Timestamp}

\item{pass_time_zone}{Whether or not to include the time zone in the
conversion to Pandas. GluonTS does not work with Pandas
Time Zones. Default: FALSE.}
}
\description{
Convert R Date or POSIXt to Pandas Timestamp
}
\examples{
\donttest{
dt <- as.Date("2011-01-01")
as_pandas_timestamp(dt)

dt_time <- as.POSIXct("2011-01-01 12:43:01", tz = "GMT")
as_pandas_timestamp(dt_time, pass_time_zone = TRUE)
}

}
