% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-nbeats.R
\name{nbeats_ensemble_fit_impl}
\alias{nbeats_ensemble_fit_impl}
\title{GluonTS N-BEATS ENSEMBLE Modeling Function (Bridge)}
\usage{
nbeats_ensemble_fit_impl(
  x,
  y,
  freq,
  prediction_length,
  id,
  epochs = 5,
  batch_size = 32,
  num_batches_per_epoch = 50,
  learning_rate = 0.001,
  learning_rate_decay_factor = 0.5,
  patience = 10,
  minimum_learning_rate = 5e-05,
  clip_gradient = 10,
  weight_decay = 1e-08,
  init = "xavier",
  ctx = NULL,
  hybridize = TRUE,
  meta_context_length = prediction_length * c(2, 4),
  meta_loss_function = list("sMAPE"),
  meta_bagging_size = 3,
  num_stacks = 30,
  num_blocks = list(1),
  widths = list(512),
  sharing = list(FALSE),
  expansion_coefficient_lengths = list(32),
  stack_types = list("G")
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{freq}{A \code{pandas} timeseries frequency such as "5min" for 5-minutes or "D" for daily.
Refer to \href{https://pandas.pydata.org/pandas-docs/stable/user_guide/timeseries.html#offset-aliases}{Pandas Offset Aliases}.}

\item{prediction_length}{Numeric value indicating the length of the prediction horizon}

\item{id}{A quoted column name that tracks the GluonTS FieldName "item_id"}

\item{epochs}{Number of epochs that the network will train (default: 5).}

\item{batch_size}{Number of examples in each batch (default: 32).}

\item{num_batches_per_epoch}{Number of batches at each epoch (default: 50).}

\item{learning_rate}{Initial learning rate (default:  10-3 ).}

\item{learning_rate_decay_factor}{Factor (between 0 and 1) by which to decrease the learning rate (default: 0.5).}

\item{patience}{The patience to observe before reducing the learning rate, nonnegative integer (default: 10).}

\item{minimum_learning_rate}{Lower bound for the learning rate (default:  5x10-5 ).}

\item{clip_gradient}{Maximum value of gradient. The gradient is clipped if it is too large (default: 10).}

\item{weight_decay}{The weight decay (or L2 regularization) coefficient. Modifies objective by adding a penalty for having large weights (default  10-8 ).}

\item{init}{Initializer of the weights of the network (default: “xavier”).}

\item{ctx}{The mxnet CPU/GPU context. Refer to using CPU/GPU in the mxnet documentation.
(default: NULL, uses CPU)}

\item{hybridize}{Increases efficiency by using symbolic programming. (default: TRUE)}

\item{meta_context_length}{The different 'context_length' (also known as 'lookback period') to use for training the models. The 'context_length' is the number of time units that condition the predictions. Default and recommended value: \verb{list(multiplier * prediction_length for multiplier in range(2, 7))}}

\item{meta_loss_function}{The different 'loss_function' (also known as metric) to use for training the models. Unlike other models in GluonTS this network does not use a distribution. Default and recommended value: \code{list("sMAPE", "MASE", "MAPE")}}

\item{meta_bagging_size}{The number of models that share the parameter combination of 'context_length' and 'loss_function'. Each of these models gets a different initialization random initialization. Default (3). Recommended value: 10}

\item{num_stacks}{The number of stacks the network should contain. Default and recommended value for generic mode: 30 Recommended value for interpretable mode: 2}

\item{num_blocks}{The number of blocks per stack. A list of ints of length 1 or 'num_stacks'. Default and recommended value for generic mode: 1. Recommended value for interpretable mode: 3.}

\item{widths}{Widths of the fully connected layers with ReLu activation in the blocks. A list of ints of length 1 or 'num_stacks'. Default and recommended value for generic mode: \code{list(512)} Recommended value for interpretable mode: \code{list(256, 2048)}}

\item{sharing}{Whether the weights are shared with the other blocks per stack. A list of ints of length 1 or 'num_stacks'. Default and recommended value for generic mode: \code{list(FALSE)} Recommended value for interpretable mode: \code{list(TRUE)}}

\item{expansion_coefficient_lengths}{If the type is "G" (generic), then the length of the expansion coefficient. If type is "T" (trend), then it corresponds to the degree of the polynomial. If the type is "S" (seasonal) then its not used. A list of ints of length 1 or 'num_stacks'. Default value for generic mode: \code{list(32)} Recommended value for interpretable mode: \code{list(3)}}

\item{stack_types}{One of the following values: "G" (generic), "S" (seasonal) or "T" (trend). A list of strings of length 1 or 'num_stacks'. Default and recommended value for generic mode: \code{list("G")} Recommended value for interpretable mode: \code{list("T","S")}}
}
\description{
GluonTS N-BEATS ENSEMBLE Modeling Function (Bridge)
}
\details{
The total number of models used is:

\verb{meta_context_length x meta_loss_function x meta_bagging_size}
}
