% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modsem_da.R
\name{modsem_da}
\alias{modsem_da}
\title{Interaction between latent variables using lms and qml approaches}
\usage{
modsem_da(
  model.syntax = NULL,
  data = NULL,
  method = "lms",
  verbose = NULL,
  optimize = NULL,
  nodes = NULL,
  convergence = NULL,
  optimizer = NULL,
  center.data = NULL,
  standardize.data = NULL,
  standardize.out = NULL,
  standardize = NULL,
  mean.observed = NULL,
  cov.syntax = NULL,
  double = NULL,
  calc.se = NULL,
  FIM = NULL,
  EFIM.S = NULL,
  OFIM.hessian = NULL,
  EFIM.parametric = NULL,
  robust.se = NULL,
  max.iter = NULL,
  max.step = NULL,
  fix.estep = NULL,
  start = NULL,
  epsilon = NULL,
  quad.range = NULL,
  ...
)
}
\arguments{
\item{model.syntax}{lavaan syntax}

\item{data}{dataframe}

\item{method}{method to use:
"lms" = laten model structural equations (not passed to lavaan).
"qml" = quasi maximum likelihood estimation of laten model structural equations (not passed to lavaan).}

\item{verbose}{should estimation progress be shown}

\item{optimize}{should starting parameters be optimized}

\item{nodes}{number of quadrature nodes (points of integration) used in lms,
increased number gives better estimates but slower computation. How many is needed, depends on the complexity of the model
For simple models you somwhere between 16-24 should be enough, for more complex higher numbers may be needed. 
For models where there is an interaction effects between and endogenous and exogenous variable 
the number of nodes should at least be 32, but practically (e.g., ordinal/skewed data) more than 32 is recommended. In cases, 
where data is non-normal it might be better to use the qml approach instead. For large
numbers of nodes, you might want to change the 'quad.range' argument.}

\item{convergence}{convergence criterion. Lower values give better estimates but slower computation.}

\item{optimizer}{optimizer to use, can be either "nlminb" or "L-BFGS-B". For LMS, "nlminb" is recommended. 
For QML, "L-BFGS-B" may be faster if there is a large number of iterations, but slower if there are few iterations.}

\item{center.data}{should data be centered before fitting model}

\item{standardize.data}{should data be scaled before fitting model, will be overridden by
standardize if standardize is set to TRUE.
NOTE: It is recommended that you estimate the model normally and then standardize the output using
`standardized_estimates()`.}

\item{standardize.out}{should output be standardized (note will alter the relationsships of
parameter constraints, since to parameters are scaled unevenly, even if they
have the same label). This does not alter the estimation of the model, only the
output.
NOTE: It is recommended that you estimate the model normally and then standardize the output using
`standardized_estimates()`.}

\item{standardize}{will standardize the data before fitting the model, remove the mean
structure of the observed variables, and standardize the output. Note that standardize.data
mean.observed, standardize.out will be overridden by standardize if standardize is set to TRUE.
NOTE: It is recommended that you estimate the model normally and then standardize the output using
`standardized_estimates()`.}

\item{mean.observed}{should mean structure of the observed variables be estimated,
will be overridden by standardize if standardize is set to TRUE.
NOTE: Not recommended unless you know what you are doing.}

\item{cov.syntax}{model syntax for implied covariance matrix (see 'vignette("interaction_two_etas", "modsem")')}

\item{double}{try to double the number of dimensions of integrations used in LMS,
this will be extremely slow, but should be more similar to mplus.}

\item{calc.se}{should standard errros be computed, NOTE: If 'FALSE' information matrix will not be computed either}

\item{FIM}{should fisher information matrix be calculated using observed of expected. must be either "observed" or "expected"}

\item{EFIM.S}{if expected fisher information matrix is computed, EFIM.S selects the sample size of the generated data}

\item{OFIM.hessian}{should observed fisher information be computed using hessian? if FALSE, it is computed using gradient}

\item{EFIM.parametric}{should data for calculating expected fisher information matrix be 
simulated parametrically (simulated based on the assumptions- and implied parameters
from the model), or non-parametrically (stochastically sampled). If you believe that 
normality assumptions are violated, 'EFIM.parametric = FALSE' might be the better option.}

\item{robust.se}{should robust standard errors be computed? Meant to be used for QML, 
can be unreliable with the LMS-approach.}

\item{max.iter}{max numebr of iterations}

\item{max.step}{max steps for the M-step in the EM algorithm (LMS)}

\item{fix.estep}{if TRUE, E-step will be fixed and the prior probabilities are set to the best prior probabilities, 
if loglikelihood is decreasing for more than 30 iterations.}

\item{start}{starting parameters}

\item{epsilon}{finite difference for numerical derivatives}

\item{quad.range}{range in z-scores to perform numerical integration in LMS using 
Gaussian-Hermite Quadratures. By default Inf, such that f(t) is integrated from -Inf to Inf, 
but this will likely be inefficient and pointless at large number of nodes. Nodes outside 
+/- quad.range will be ignored.}

\item{...}{additional arguments to be passed to the estimation function}
}
\value{
modsem_lms or modsem_qml object
}
\description{
modsem_da is a function for estimating interaction effects between latent variables,
in structural equation models (SEMs), using distributional analytic (DA) approaches.
Methods for estimating interaction effects in SEM's can basically be split into
two frameworks: 1. Product Indicator based approaches ("dblcent", "rca", "uca",
"ca", "pind"), and 2. Distributionally based approaches ("lms", "qml").
modsem_da() handles the latter, and can estimate models using both qml and lms
necessary syntax, and variables for the estimation of models with latent product indicators.
NOTE: run 'default_settings_da()' to see default arguments.
}
\examples{
library(modsem)
# For more examples check README and/or GitHub.
# One interaction
m1 <- "
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
"

\dontrun{
# QML Approach
est1 <- modsem_da(m1, oneInt, method = "qml")
summary(est1)


# Theory Of Planned Behavior
tpb <- "
# Outer Model (Based on Hagger et al., 2007)
  ATT =~ att1 + att2 + att3 + att4 + att5
  SN =~ sn1 + sn2
  PBC =~ pbc1 + pbc2 + pbc3
  INT =~ int1 + int2 + int3
  BEH =~ b1 + b2

# Inner Model (Based on Steinmetz et al., 2011)
  # Covariances
  ATT ~~ SN + PBC
  PBC ~~ SN
  # Causal Relationsships
  INT ~ ATT + SN + PBC
  BEH ~ INT + PBC
  BEH ~ INT:PBC
"

# lms approach
estTpb <- modsem_da(tpb, data = TPB, method = lms)
summary(estTpb)
}

}
