% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_paths_wright.R
\name{trace_path}
\alias{trace_path}
\title{Estimate formulas for (co-)variance paths using Wright's path tracing rules}
\usage{
trace_path(
  pt,
  x,
  y,
  parenthesis = TRUE,
  missing.cov = FALSE,
  measurement.model = FALSE,
  maxlen = 100,
  ...
)
}
\arguments{
\item{pt}{A data frame with columns \code{lhs}, \code{op}, \code{rhs}, and \code{mod}, from \link{modsemify}}

\item{x}{Source variable}

\item{y}{Destination variable}

\item{parenthesis}{If \code{TRUE}, the output will be enclosed in parenthesis}

\item{missing.cov}{If \code{TRUE}, covariances missing from the model syntax will be added}

\item{measurement.model}{If \code{TRUE}, the function will use the measurement model}

\item{maxlen}{Maximum length of a path before aborting}

\item{...}{Additional arguments passed to \link{trace_path}}
}
\value{
A string with the estimated path (simplified if possible)
}
\description{
This function estimates the path from \code{x} to \code{y} using the path tracing rules.
Note that it only works with structural parameters, so \code{"=~"} are ignored, unless
\code{measurement.model = TRUE}.
If you want to use the measurement model,
\code{"~"} should be in the \code{mod} column of \code{pt}.
}
\examples{
library(modsem)
m1 <- '
  # Outer Model
  X =~ x1 + x2 +x3
  Y =~ y1 + y2 + y3
  Z =~ z1 + z2 + z3

  # Inner model
  Y ~ X + Z + X:Z
'
pt <- modsemify(m1)
trace_path(pt, x = "Y", y = "Y", missing.cov = TRUE) # variance of Y
}
