% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{module}
\alias{export}
\alias{import}
\alias{module}
\alias{use}
\title{Define Modules in R}
\usage{
module(expr = { }, topEncl = if (interactive()) baseenv() else
  parent.frame())

import(from, ..., where = parent.frame())

use(module, attach = FALSE, where = parent.frame())

export(..., where = parent.frame())
}
\arguments{
\item{expr}{an expression}

\item{topEncl}{(environment) the root of the local search path}

\item{from}{(character, or unquoten expression) a package name}

\item{...}{(character, or unquoted expression) names to import from package}

\item{where}{(environment) important for testing}

\item{module}{(character | list) a module as filename or object}

\item{attach}{(logical) whether to attach the module to the search path}
}
\description{
Use \code{module} to define self contained organizational units. Modules have
their own search path. \code{import} can be used to import packages.
\code{use} can be used to import other modules.
}
\examples{
\dontrun{
vignette("modulesInR", "module")
}

}

