% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module.R
\name{module}
\alias{export}
\alias{import}
\alias{module}
\alias{print.module}
\alias{use}
\title{Define Modules in R}
\usage{
module(expr = { }, topEncl = if (identical(topenv(parent.frame()),
  globalenv())) baseenv() else parent.frame())

\method{print}{module}(x, ...)

import(from, ..., where = parent.frame())

use(module, attach = FALSE, ..., where = parent.frame())

export(..., where = parent.frame())
}
\arguments{
\item{expr}{an expression}

\item{topEncl}{(environment) the root of the local search path}

\item{x}{a module}

\item{...}{(character, or unquoted expression) names to import from package
or names to export from module. For exports a character of length 1 with a
leading "^" is interpreted as regular expression.}

\item{from}{(character, or unquoted expression) a package name}

\item{where}{(environment) important for testing}

\item{module}{(character | list) a module as file- or folder-name or a list
representing a module.}

\item{attach}{(logical) whether to attach the module to the search path}
}
\description{
Use \code{module} to define self contained organizational units. Modules have
their own search path. \code{import} can be used to import packages.
\code{use} can be used to import other modules.
}
\details{
\code{topEncl} is the environment where the search of the module ends. This
is  (most of the time) the base package. When
\code{identical(topenv(parent.frame()), globalenv())} is false it (most
likely) means that the module is part of a package. In that case the module
defines a sub unit within a package but has access to the packages namespace.
This is only relevant if you use the function module explicitly. Most likely
you will instead use the function 'use' or 'as.module' instead, where the top
enclosing environment is always base.

\code{import} and \code{use} are no replacements for \link{library} and
\link{attach}. Both will work when called in the \code{.GlobalEnv} but should
only be used for development and debugging of modules.

\code{export} will never export a function with a leading "." in its name.
}
\examples{
\dontrun{
vignette("modulesInR", "modules")
}

}

