% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoRes.R
\name{pseudoRes}
\alias{pseudoRes}
\title{Pseudo-residuals}
\usage{
pseudoRes(m)
}
\arguments{
\item{m}{A \code{\link{momentuHMM}}, \code{\link{miHMM}}, or \code{\link{miSum}} object.}
}
\value{
A list of psuedo-residuals for each data stream (e.g., 'stepRes', 'angleRes')
}
\description{
The pseudo-residuals of momentuHMM models, as described in Zucchini and McDonad (2009).
}
\details{
If some turning angles in the data are equal to pi, the corresponding pseudo-residuals
will not be included. Indeed, given that the turning angles are defined on (-pi,pi], an angle of pi
results in a pseudo-residual of +Inf (check Section 6.2 of reference for more information on the
computation of pseudo-residuals).

A continuity adjustment (adapted from Harte 2017) is made for discrete probability distributions. When
the data are near the boundary (e.g. 0 for ``pois''; 0 and 1 for ``bern''), then the pseudo residuals can
be a poor indicator of lack of fit.

Note that pseudo-residuals for multiple imputation analyses are based on pooled parameter 
estimates and the means of the data values across all imputations.
}
\examples{
# m is a momentuHMM object (as returned by fitHMM), automatically loaded with the package
m <- example$m
res <- pseudoRes(m)
qqnorm(res$stepRes)
qqnorm(res$angleRes)

}
\references{
Harte, D. 2017. HiddenMarkov: Hidden Markov Models. R package version 1.8-8.

Zucchini, W. and MacDonald, I.L. 2009.
Hidden Markov Models for Time Series: An Introduction Using R.
Chapman & Hall (London).
}
