% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turnAngle.R
\name{turnAngle}
\alias{turnAngle}
\title{Turning angle}
\usage{
turnAngle(x, y, z, type = "UTM", angleCov = FALSE)
}
\arguments{
\item{x}{First point}

\item{y}{Second point}

\item{z}{Third point}

\item{type}{\code{'UTM'} if easting/northing provided (the default), \code{'LL'} if longitude/latitude.}

\item{angleCov}{logical indicating to not return NA when x=y or y=z. Default: FALSE (i.e. NA is returned if x=y or y=z).}
}
\value{
The angle between vectors (x,y) and (y,z).  

If \code{type='LL'} then turning angle is calculated based on initial bearings using \code{\link[geosphere]{bearing}}.
}
\description{
Used in \code{\link{prepData}} and \code{\link{simData}}.
}
\examples{
\dontrun{
x <- c(0,0)
y <- c(4,6)
z <- c(10,7)
momentuHMM:::turnAngle(x,y,z)
}
}
