% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mytable.R
\name{mytable_sub}
\alias{mytable_sub}
\title{Produce table for descriptive statistics}
\usage{
mytable_sub(x, data, use.labels = TRUE, use.column.label = TRUE,
  max.ylev = 5, maxCatLevel = 20, digits = 1, method = 1,
  catMethod = 2, show.all = FALSE, exact = FALSE, show.total = FALSE)
}
\arguments{
\item{x}{An object of class "formula". Left side of ~ must contain the
name of one grouping variable or two grouping variables in an
additive way(e.g. sex+group~), and the right side of ~ must have
variables in an additive way.}

\item{data}{A data.frame contains data for analysis}

\item{use.labels}{Logical. Whether or not use labels.}

\item{use.column.label}{Logical. Whether or not use column labels.}

\item{max.ylev}{An integer indicating the maximum number of levels of grouping
variable ('y'). If a colummn have unique values less than max.ylev
it is treated as a categorical variable. Default value is 5.}

\item{maxCatLevel}{An integer indicating the maximum number of unique levels of categorial variable.
If a colummn have unique values more than maxCatLevel, categorical summarization
will not be performed.}

\item{digits}{An integer indicating the number of decimal places (round) or
significant digits to be used. Default value is 1.}

\item{method}{An integer indicating methods for continuous variables.
Possible values in methods are
\describe{
   \item{1}{forces analysis as normal-distributed}
   \item{2}{forces analysis as continuous non-normal}
   \item{3}{performs a Shapiro-Wilk test to decide between
           normal or non-normal}
}
Default value is 1.}

\item{catMethod}{An integer indicating methods for categorical variables.
Possible values in methods are
\describe{
   \item{0}{Perform chisq.test first. If warning present, perform fisher test}
   \item{1}{Perform chisq.test without continuity correction}
   \item{2}{Perform chisq.test with continuity correction}
   \item{3}{perform fisher.test}
   \item{4}{perform prop.trend test}
}
Default value is 2.}

\item{show.all}{A logical value indicating whether or not all statistical
values have to be shown in table. Default value is FALSE.}

\item{exact}{A logical value indicating whether or not permit call with approximate
parameter. If true, only exact column name permitted.Default value is FALSE.}

\item{show.total}{A logical value indicating whether or not show total group value.
Default value is FALSE.}
}
\value{
An object of class "mytable".
     'print' returns a table for descriptive statistics.
     'summary' returns a table with all statistical values.
}
\description{
Produce table for descriptive statistics by groups for several variables easily.
Depending on  the nature of these variables, different descriptive statistical
methods were used(t-test, ANOVA,Kruskal-Wallis, chisq, Fisher,...)
}
