% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{predict.morf.forest}
\alias{predict.morf.forest}
\title{Prediction Method for morf.forest Objects}
\usage{
\method{predict}{morf.forest}(object, data, type = "response", ...)
}
\arguments{
\item{object}{An \code{morf.forest} object.}

\item{data}{Data set of class \code{data.frame}. It must contain at least the same covariates used to train the forests.}

\item{type}{Type of prediction. Either \code{"response"} or \code{"terminalNodes"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prediction results.
}
\description{
Prediction method for class \code{morf.forest}.
}
\details{
If \code{type === "response"} (the default), the predicted conditional class probabilities are returned. If forests are 
honest, these predictions are honest.\cr

If \code{type == "terminalNodes"}, the IDs of the terminal node in each tree for each observation in \code{data} are returned.
}
\seealso{
\code{\link{morf}}, \code{\link{marginal_effects}}
}
\author{
Riccardo Di Francesco
}
\keyword{internal}
