% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_functions.R
\name{mortaar_life_table}
\alias{mortaar_life_table}
\alias{as.mortaar_life_table_list}
\alias{as.mortaar_life_table}
\title{\strong{mortaar_life_table} and \strong{mortaar_life_table_list}}
\usage{
as.mortaar_life_table_list(x, ...)

as.mortaar_life_table(x, ...)
}
\arguments{
\item{x}{an object}

\item{...}{further arguments passed to or from other methods}
}
\description{
The \strong{mortaar_life_table} is the central data structure of the
\code{mortAAR} package. It's a data.frame with set of custom methods and
variables. Please see \code{mortAAR::life.table} for a description
of the variables. Further available variables are ignored. \cr
If an object is of class data.frame or tibble (tbl & tbl_df), it can be
converted to an object of class mortaar_life_table. The only requirement
is that it contains at least the essential columns \strong{a} and \strong{Dx}.
The \code{as} function adds the string "mortaar_life_table" to the classes vector. \cr
The \strong{mortaar_life_table_list} is a list of mortaar_life_tables.
It can contain the additional attribute \code{group} that stores a string with
the name of the grouping variable relevant for the separation of the
different mortaar_life_tables in the list. The group variable is only relevant
for plot and print aesthetics.
}
\examples{
# a mortaar_life_table can be put together manually:
as.mortaar_life_table(data.frame(a = c(20, 20, 20), Dx = c(10, 15, 20)))

as.mortaar_life_table_list(
  list(
    life.table(schleswig_ma[c("a", "Dx")]),
    life.table(schleswig_ma[c("a", "Dx")])
  )
)

}
