% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps2.R
\name{sp2df}
\alias{sp2df}
\title{Transforms a shapefile into a dataframe}
\usage{
sp2df(map, ...)
}
\arguments{
\item{map}{A map object of class \code{SpatialPolygonsDataFrame}}

\item{...}{Other arguments, currently ignored}
}
\value{
A dataframe, in which the first 7 columns hold geographical
information (ex: \code{long} and \code{lat})
}
\description{
This function takes in a shapefile (formal class of
\code{SpatialPolygonsDataFrame}) and transforms it into a dataframe
}
\examples{

\dontrun{ 
if(require(maptools)) {
  data(wrld_simpl)
  worldmap <- sp2df(wrld_simpl)
}

if ( require(ggplot2) && require(maptools) ) { 
  data(wrld_simpl)
  World <- sp2df(wrld_simpl)
  World2 <- merge(World, Countries, by.x="NAME", by.y="maptools", all.y=FALSE)
  Mdata <- merge(Alcohol, World2, by.x="country", by.y="gapminder", all.y=FALSE) 
  Mdata <- Mdata[order(Mdata$order),]
  qplot( x=long, y=lat, fill=ntiles(alcohol,5), 
         data=subset(Mdata, year==2008), group = group, 
                     geom="polygon")
}
}
}

