\name{resample}
\alias{deal}
\alias{resample}
\alias{sample}
\alias{sample.data.frame}
\alias{sample.default}
\alias{sample.factor}
\alias{sample.matrix}
\alias{shuffle}
\title{More Random Samples}
\usage{
  resample(..., replace = TRUE)

  deal(...)

  shuffle(x, replace = FALSE, prob = NULL, groups = NULL,
    orig.ids = FALSE)

  sample(x, size, replace = FALSE, ...)

  \method{sample}{default} (x, size, replace = FALSE,
    prob = NULL, groups = NULL, orig.ids = FALSE, ...)

  \method{sample}{data.frame} (x, size, replace = FALSE,
    prob = NULL, groups = NULL, orig.ids = TRUE,
    fixed = names(x), shuffled = c(),
    invisibly.return = NULL, ...)

  \method{sample}{matrix} (x, size, replace = FALSE,
    prob = NULL, groups = NULL, orig.ids = FALSE, ...)

  \method{sample}{factor} (x, size, replace = FALSE,
    prob = NULL, groups = NULL, orig.ids = FALSE,
    drop.unused.levels = FALSE, ...)
}
\arguments{
  \item{x}{Either a vector of one or more elements from
  which to choose, or a positive integer.}

  \item{size}{a non-negative integer giving the number of
  items to choose.}

  \item{replace}{Should sampling be with replacement?}

  \item{prob}{A vector of probability weights for obtaining
  the elements of the vector being sampled.}

  \item{groups}{a vector (or variable in a data frame)
  specifying groups to sample within. This will be recycled
  if necessary.}

  \item{orig.ids}{a logical; should origianal ids be
  included in returned data frame?}

  \item{\dots}{additional arguments passed to
  \code{\link[base]{sample}} or
  \code{\link[mosaic]{sample}}.}

  \item{shuffled}{a vector of column names. these variables
  are reshuffled individually (within groups if
  \code{groups} is specified), breaking associations among
  these columns. examples.}

  \item{fixed}{a vector of column names.  These variables
  are shuffled en masse, preserving associations among
  these columns.}

  \item{invisibly.return}{a logical, should return be
  invisible?}

  \item{drop.unused.levels}{a logical, should unused levels
  be dropped?}
}
\description{
  These functions simplify and unify sampling in various
  ways.
}
\details{
  These functions are wrappers around \code{\link{sample}}
  providing different defaults and natural names.
}
\examples{
# 100 Bernoulli trials -- no need for replace=TRUE
resample(0:1, 100)
tally(resample(0:1, 100))
Small <- sample(KidsFeet, 10)
resample(Small)
tally(~ sex, data=resample(Small))
tally(~ sex, data=resample(Small))
# fixed marginals for sex
tally(~ sex, data=Small)
tally(~ sex, data=resample(Small, groups=sex))
# shuffled can be used to reshuffle some variables within groups
# orig.ids shows where the values were in original data frame.
Small <- transform(Small,
   id1 = paste(sex,1:10, sep=":"),
   id2 = paste(sex,1:10, sep=":"))
resample(Small, groups=sex, shuffled=c("id1","id2"))
deal(Cards, 13)    # A Bridge hand
shuffle(Cards)
}

