% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Integrate.R
\name{Integrate}
\alias{Integrate}
\title{Integrate a function}
\usage{
Integrate(tilde, domain, ..., tol = 1e-05)
}
\arguments{
\item{tilde}{A tilde expression describing the function.}

\item{domain}{The domain over which to perform the integration}

\item{\dots}{values assigned to free parameters in the tilde expression, e.g. a=1}

\item{tol}{numerical tolerance for integration, see \code{stats::integrate()}.}
}
\description{
Calculates the definite integral of a function. That is, the result of the
integration will be a number. There can be no free parameters in the function
being integrated. (If you want free parameters, use \code{antiD()}.) \code{Integrate()} can
handle integration over up to 3 variables.
}
\details{
For functions constructed as a spline interpolant, \code{Integrate()} can handle
more segments than \code{antiD()}. It's reasonable to do up to 2000 segments with \code{Integrate()},
whereas \code{antiD()} handles only about 100.
}
\examples{
Integrate(dnorm(x) ~ x, domain(x=-2:2))
Integrate(dnorm(x, sd=sigma) ~ x, domain(x=-2:2), sigma=2)
Integrate(sqrt(1- x^2) ~ x, domain(x=-1:1)) # area of semi-circle

}
