% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Planets.R
\docType{data}
\name{Planets}
\alias{Planets}
\title{NASA data on planets}
\format{
A data frame with 10 rows and these variables:
\itemize{
\item \code{planet} name of the planet
\item \code{mass}  in 10^24 kg
\item \code{diameter} in  km
\item \code{density} in kg/m^3
\item \code{gravity}  in m/s^2
\item \code{escape_velocity} in km/s
\item \code{rotational_period} in hours
\item \code{day_length} in  hours
\item \code{distance_from_sun} in 10^6 km
\item \code{perihelion} in  10^6 km
\item \code{aphelion} in  10^6  km
\item \code{orbital_period} in days
\item \code{orbital_velocity}  in km/s
\item \code{orbital_inclination} in degrees
\item \code{orbital_eccentricity}
\item \code{obliquity_to_orbit} in  degrees
\item \code{mean_temperature} in C
\item \code{surface_pressure} in  bars
\item \code{n_moons} a count
\item \code{ring_system} does the planet have a ring system
\item \code{global_magnetic_field} does the planet have a magnetic field
}
}
\source{
https://nssdc.gsfc.nasa.gov/planetary/factsheet/
}
\usage{
data(Planets)
}
\description{
NASA data on planets
}
\details{
Two of the rows, MOON and  PLUTO, are not considered planets. The
orbital parameters  of the MOON are with respect to EARTH. Others are with respect
to the Sun. Negative rotation period denotes a rotation opposite that of most of the
other planets.
}
\keyword{datasets}
