% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamics.R
\name{streamlines}
\alias{streamlines}
\alias{flow_field}
\alias{trajectory_euler}
\title{Dynamical systems calculations and graphics}
\usage{
streamlines(..., npts = 8, dt = 0.01, nsteps = 10, color = "black", alpha = 1)

flow_field(..., npts = 8, scale = 0.8, color = "black", alpha = 1)

trajectory_euler(..., dt = 0.01, nsteps = 4, full = TRUE, every = 1)
}
\arguments{
\item{\dots}{The first arguments should describe the dynamics. See details.}

\item{npts}{The number of points on an edge of the grid}

\item{dt}{time step (e.g. 0.01)}

\item{nsteps}{how many Euler steps to take}

\item{color}{What color to use}

\item{alpha}{What alpha to use}

\item{scale}{Number indicating how long to draw arrows. By default,
the longest arrows take up a full box in the grid}

\item{full}{report the derivative and the step size for each variable}

\item{every}{n, report will contain every nth step}
}
\description{
\itemize{
\item \code{streamlines()} draws raindrop-shaped paths at a randomized grid of points that follow trajectories
\item \code{flow_field()} draws arrows showing the flow at a grid of points
\item \code{trajectory_euler()} compute an Euler solution. ()
}
}
\details{
The dynamical functions themselves will be formulas like \code{dx ~ a*x*y} and \code{dy ~ y/x}.
Initial conditions will be arguments of the form \code{x=3} and \code{y=4}.
If there are parameters in the dynamical functions, you should also
add the parameter values, for instance \code{a=2}.

For \code{flow_field()} and \code{streamlines()} you do not need to specify
initial conditions. The grid will be set by the domain argument.

The graphics functions are all arranged to accept,
if given, a ggplot object piped in. The new graphics layer will be drawn on
top of that. If there is no ggplot object piped in, then the graphics
will be made as a first layer, which can optionally piped into other
ggformula functions or \code{+} into ggplot layers.
}
\examples{
streamlines(dx ~ x+y, dy~ x-y, domain(x=0:6, y=0:3))
flow_field(dx ~ x+y, dy~ x-y, domain(x=0:6, y=0:3))
Dyn <- makeODE(dx ~ 0.06*x, dy ~-x - y, domain(t=0:20), dt=0.1,x=3, y=4)
streamlines(Dyn, domain(x=-5:5, y=-5:5), npts=15)
flow_field(Dyn, domain(x=-6:6, y=-10:10))
trajectory_euler(dx ~ -y, dy ~ .5*x, x=3, y=3)
rabbits <- drabbit ~ 0.2*rabbit - 0.01*rabbit*fox
foxes <- dfox ~ -.2*fox + 0.0005*rabbit*fox 
trajectory_euler(rabbits, foxes, rabbit=100, fox=3, dt=0.1, nsteps=500, every=10)

}
