% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Countries}
\alias{Countries}
\title{Countries}
\format{A data frame with 258 observations on the following variables.
  \itemize{
    \item{\code{worldmap}} {region name http://mappinghacks.com/ data sets}
    \item{\code{gapminder}} {country name in GapMinder data sets}
    \item{\code{maps}} {region name in \code{maps} data sets}
  }}
\usage{
data(Countries)
}
\description{
A data frame containing country names as used by GapMinder and the \code{maps}
package to facilitate converstion between the two.
}
\details{
The "countries" in the \code{maps} data include several other geographic regions (bodies
of water, islands belonging to other countries, Hawaii, etc.) that are not countries.
Furthermore, the \code{maps} countries do not include many of the countries that
have been created since ca. 2000.  The mapping is therefore many-to-many, and also
includes some NAs when there is no appropriate mapping.  Bodies of water in the
\code{maps} data, for example, are not assigned a country in the GapMinder.
}
\examples{
data(Countries)
subset(Countries, maps=="Yugoslavia")  # Where has Yugoslavia gone?
subset(Countries, is.na(gapminder))    # Things from maps with no GapMinder equivalent
subset(Countries, is.na(maps))         # Things from GapMinder with no maps equivalent
}
\keyword{datasets}

