% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{collectResult}
\alias{collectResult}
\title{Collect Result Information}
\usage{
collectResult(
  ecr.object,
  aggregate.perresult = list(domHV = function(x) computeHV(x, ref.point)),
  aggregate.perobjective = list("min", "mean", "max"),
  ref.point = smoof::getRefPoint(ecr.object$control$task$fitness.fun),
  cor.fun = cor
)
}
\arguments{
\item{ecr.object}{\verb{[MosmafsResult]} \code{slickEcr()} result to analyse.}

\item{aggregate.perresult}{\verb{[list]} list of functions
to apply to fitness and holdout fitness. Every entry must either be
a \code{character(1)} naming the function to use, or a function, in which
that entry must have a name. Each function must return exactly one
numeric value when fed a fitness matrix of one generation. This is
ignored for single-objective runs.}

\item{aggregate.perobjective}{\verb{[list]} list of functions
to apply to fitness and holdout fitness matrix rows, formatted like
\code{aggregate.perresult}. Each function must return exactly one numeric
value when fed a fitness vector.}

\item{ref.point}{\verb{[numeric]} reference point to use for HV computation.}

\item{cor.fun}{\verb{[function]} function to use for calculation of
correlation between objective and holdout. Must take two \code{numeric}
arguments and return a \code{numeric(1)}.}
}
\value{
\code{data.frame}
}
\description{
Merge both \code{log} and \code{log.newinds} data for a complete \code{data.frame}
with information about progress (both on training data and on
holdout data) and ressource usage.
}
\examples{
library(mlrCPO)

# Setup of optimization problem 
ps.simple <- pSS(
 a: numeric [0, 10],
 selector.selection: logical^10)
 
mutator.simple <- combine.operators(ps.simple,
 a = mutGauss,
 selector.selection = mutBitflipCHW)
 
crossover.simple <- combine.operators(ps.simple,
 a = recSBX,
 selector.selection = recPCrossover)

initials <- sampleValues(ps.simple, 30, discrete.names = TRUE)

fitness.fun <- smoof::makeMultiObjectiveFunction(
 sprintf("simple test"),
 has.simple.signature = FALSE, par.set = ps.simple, n.objectives = 2, 
 noisy = TRUE,
 ref.point = c(10, 1),
 fn = function(args, fidelity = NULL, holdout = FALSE) {
   pfeat <- mean(args$selector.selection)
   c(perform = args$a, pfeat = pfeat)
 })
fitness.fun.single <- smoof::makeMultiObjectiveFunction(
 sprintf("simple test"),
 has.simple.signature = FALSE, par.set = ps.simple, n.objectives = 1, 
 noisy = TRUE,
 ref.point = c(10),
 fn = function(args, fidelity = NULL, holdout = FALSE) {
   propfeat <- mean(args$selector.selection)
   c(propfeat = propfeat)
 })

# Run NSGA-II
results <- slickEcr(fitness.fun = fitness.fun, lambda = 10, population = initials, 
 mutator = mutator.simple, recombinator = crossover.simple, generations = 10)

# Collect results
colres <- collectResult(results)
print(colres)
 
}
