% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosum.R
\name{mosum}
\alias{mosum}
\title{MOSUM statistic}
\usage{
mosum(x, G, G.right = NA, var.est.method = "mosum", var.custom = NULL,
  boundary.extension = T)
}
\arguments{
\item{x}{input data (\code{numeric} vector or object of class \code{ts})}

\item{G}{an integer value for the length of the moving sum window; 
alternatively a number between 0 and 0.5 describing the moving sum bandwidth
relative to n (the length of x);}

\item{G.right}{iff \code{!is.na(G.right)}, the asymmetric bandwidth (G,G.right)
will be used;}

\item{var.est.method}{how the variance should be estimated;
possible values are
\itemize{
   \item{"custom" if a vector is to be parsed by the user;
    use \code{var.custom} in this case to to so}
   \item{"mosum" for the both-sided MOSUM variance estimator}
   \item{"mosum.min" for the minimum of the sample variance estimates from the left and right summation windows}
}}

\item{var.custom}{a numeric vector (of the same length as \code{x}) containing
local estimates of the variance or long run variance; use iff \code{var.est.method=custom}}

\item{boundary.extension}{a logical value indicating whether the boundary
values should be filled-up with CUSUM values}
}
\value{
S3 \code{mosum} object, which contains the following fields:
   \item{x}{the numeric input vector provided}
   \item{G,symmetric,G.right}{input parameters}
   \item{var.est.method,var.custom,boundary.extension}{input parameters}
   \item{stat}{statistical result values; note that the first and last G values are \code{NA} iff \code{boundary.extension=F}}
   \item{rollsums}{equals \code{stat*sqrt(var.estimation)}}
   \item{var.estimation}{the local variance estimation according 
   to \code{var.est.method}}
}
\description{
Computes the statistical values for the MOSUM test for changes in the mean.
}
\details{
This class only contains the values for the MOSUM statistic.
For statistical evaluation and changepoint extraction, use
\link[mosum]{mosum.test} and \link[mosum]{mosum.cpts}.
See also \link[mosum]{multiscale.cpts}.
}
\examples{
# Statistical values and variance est. for independent data
x <- piecewiseStationary_timeSeries(lengths=rep(100,3), means=c(0,5,-2), sds=rep(1,3))
m <- mosum(x, G=40)
par(mfcol=c(3,1))
plot.ts(x)
plot(m)
plot.ts(m$var.estimation)
par(mfcol=c(1,1))
}
\references{
A. Meier, C. Kirch and H. Cho.
\emph{mosum: A Package for Moving Sums in Change Point Analysis.}
Unpublished manuscript, 2018+.

B. Eichinger and C. Kirch.
\emph{A MOSUM procedure for the estimation of multiple random change points.}
Bernoulli, Volume 24, Number 1 (2018), 526-564.
}
