% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_extract.R
\name{lsp_extract}
\alias{lsp_extract}
\title{Extracts a local landscape}
\usage{
lsp_extract(x, window, id, output = "stars")
}
\arguments{
\item{x}{Object of class \code{stars}, \code{stars_proxy}, or terra's \code{SpatRaster}.}

\item{window}{Specifies areas for analysis. It can be either: \code{NULL}, a numeric value, or an \code{sf} object.}

\item{id}{Id of the local landscape - it is possible to find in the output of \code{lsp_signature()}, \code{lsp_search()}, \code{lsp_compare()}, or \code{lsp_add_clusters()}.}

\item{output}{The class of the output. Either \code{"stars"} or \code{terra}}
}
\value{
A \code{stars}or \code{terra} object cropped to the extent of a selected local landscape
}
\description{
Extracts a local landscape from categorical raster data based on its id and provided \code{window} argument.
}
\examples{
library(stars)
landform = read_stars(system.file("raster/landforms.tif", package = "motif"))
ecoregions = read_sf(system.file("vector/ecoregionss.gpkg", package = "motif"))

extract1 = lsp_extract(x = landform, window = 100, id = 25)
plot(extract1)

ecoregions = st_transform(ecoregions, st_crs(landform))
extract2 = lsp_extract(x = landform, window = ecoregions["id"], id = 11)
plot(extract2)

\donttest{
# larger data example
library(stars)
landform = read_stars(system.file("raster/landform.tif", package = "motif"))
ecoregions = read_sf(system.file("vector/ecoregions.gpkg", package = "motif"))

extract1 = lsp_extract(x = landform, window = 100, id = 1895)
plot(extract1)

ecoregions = st_transform(ecoregions, st_crs(landform))
extract2 = lsp_extract(x = landform, window = ecoregions["id"], id = 7)
plot(extract2)
}
}
