% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsp_add_spatial.R
\name{lsp_add_terra}
\alias{lsp_add_terra}
\title{Creates or adds a terra object}
\usage{
lsp_add_terra(x = NULL, window = NULL)
}
\arguments{
\item{x}{Object of class \code{stars} or \code{lsp}.
For \code{stars}, \code{window} or \code{window_size} can be used.}

\item{window}{Specifies areas for analysis. It can be either: \code{NULL}, a numeric value, or an \code{sf} object. If \code{window=NULL} calculations are performed for a whole area. If the \code{window} argument is numeric, it is a length of the side of a square-shaped block of cells. Expressed in the numbers of cells, it defines the extent of a local pattern. If an \code{sf} object is provided, each feature (row) defines the extent of a local pattern. The \code{sf} object should have one attribute (otherwise, the first attribute is used as an id).}
}
\value{
A \code{terra} object converted from the input object or a provided set of parameters
}
\description{
Creates or adds a terra object based on the input object or a set of parameters.
It accepts either an object of class \code{stars} or \code{lsp}.
In the first case, the output is created based on
the \code{window} parameter.
In the second case, the output converts the \code{lsp} object into
a \code{terra} object.
}
\examples{
library(stars)
library(terra)
landform = read_stars(system.file("raster/landforms.tif", package = "motif"))
#plot(landform)
landform_lsp = lsp_add_terra(landform, window = 100)
#plot(landform_lsp)

#lc_cove = lsp_signature(landform, type = "cove", window = 200, normalization = "pdf")
#lc_cove_lsp = lsp_add_terra(lc_cove)
#plot(lc_cove_lsp)
#plot(lc_cove_lsp["na_prop"])

}
