% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_meta.R
\name{run_meta}
\alias{run_meta}
\title{Running hierarchical models}
\usage{
run_meta(
  rv,
  set_target = c("hr", "ctsd"),
  subpop = FALSE,
  trace = FALSE,
  iter_step = 2,
  .automate_seq = FALSE,
  .only_max_m = FALSE,
  .lists = NULL
)
}
\arguments{
\item{rv}{A list containing outputs, settings and data objects. Must not be NULL.}

\item{set_target}{Character. Research target: \code{"hr"} for home range or \code{"ctsd"} for speed & distance.}

\item{subpop}{Logical. If TRUE, will run meta-analyses with groups. Default is FALSE.}

\item{trace}{Logical. If TRUE, prints progress messages. Default is FALSE.}

\item{iter_step}{Numeric. The size of each iteration step. Default is 2.}

\item{.automate_seq}{Logical. If TRUE, overwrites sequence automatically to improve plot readability. Default is FALSE.}

\item{.only_max_m}{Logical. If TRUE, will only run the maximum number of individuals. Default is FALSE.}

\item{.lists}{A list containing already created meta inputs. Default is NULL.}
}
\value{
The outputs of the \code{run_meta_resampled} function for a single combination.
}
\description{
This function wraps around the \code{run_meta_resampled} function to run hierarchical models (with no resamples) for a quick evaluation.
}
