% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biparentalDominant.R
\name{biparentalDominant}
\alias{biparentalDominant}
\title{Make markers in a biparental cross dominant}
\usage{
biparentalDominant()
}
\value{
An object of internal type \code{biparentalDominant}, which can be combined with an object of class \code{mpcross} using the addition operator.
}
\description{
Change the markers in a biparental cross from fully informative to dominant. The dominant founder is chosen randomly for every marker. The transformation is applied to an object using the addition operator, see the example below for details.
}
\examples{
#Simulate an F2 design
f2Pedigree <- f2Pedigree(1000)
map <- qtl::sim.map(len = 100, n.mar = 11, include.x=FALSE)
cross <- simulateMPCross(map = map, pedigree = f2Pedigree, mapFunction = haldane, seed = 1)
founders(cross)
finals(cross)[1:10,]
#The heterozygotes are initially coded as 3
hetData(cross)[[1]]
#Make all markers dominant
dominantCross <- cross + biparentalDominant()
founders(dominantCross)
finals(dominantCross)[1:10,]
#The heterozygotes are now coded the same as one of the homozygotes
hetData(dominantCross)[1:4]
}
