% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilityData.R
\name{probabilityData}
\alias{probabilityData}
\alias{probabilityData,geneticData-method}
\alias{probabilityData,mpcrossMapped-method}
\title{Get IBD probability data}
\usage{
probabilityData(object, ...)

\S4method{probabilityData}{geneticData}(object, ...)

\S4method{probabilityData}{mpcrossMapped}(object, ...)
}
\arguments{
\item{object}{The \code{mpcross} object from which to extract the probability data.}

\item{...}{Additional options. Only \code{design} is supported, and gets the probability data for only a single experiment.}
}
\value{
A numeric matrix containing the IBD probabliity data, or a list of such matrices in the case of multiple experiments within a single object.
}
\description{
Get the identity-by-descent probability data from an mpcross object.
}
\details{
mpMap2 stores IBD probabilities in a matrix where the number of rows is the number of alleles times the number of genetic lines, and the columns are the positions at which probabilities are calculated. In the example below, the row names are \code{L115 - L1, L115 - L2, L115 - L3, L115 - L4, L120 - L1}, etc, and the column names are \code{DXM1, DXM2, DXM3}, etc. So, for example, for a population generated from four founders and assumed to be totally inbred, the first four values in the first column are the probabilities that genetic line 1 carries alleles from specific founders, at a specific position. The first four columns give the probabilities for genetic line 2 at the next position, etc. 

This can be an inconvenient layout for some operations. This function returns a matrix where the alleles appear as part of the columns, rather than the rows. For example, after applying this function to the given example, the first four values in the first row will be the probabilities that genetic line 1 carries alleles from specific founders, at a specific position.
}
\examples{
data(simulatedFourParentData)
crossSNP <- simulatedFourParentData + multiparentSNP(keepHets = FALSE)
mapped <- mpcrossMapped(crossSNP, map = simulatedFourParentMap)
probabilities <- computeGenotypeProbabilities(mapped, error = 0.05)
probabilityData <- probabilityData(probabilities)
probabilityData[1:5, 1:5]
}
