% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fourParentPedigreeSingleFunnel.R
\name{fourParentPedigreeSingleFunnel}
\alias{fourParentPedigreeSingleFunnel}
\title{Generate a four-parent pedigree}
\usage{
fourParentPedigreeSingleFunnel(
  initialPopulationSize,
  selfingGenerations,
  nSeeds = 1L,
  intercrossingGenerations
)
}
\arguments{
\item{initialPopulationSize}{The number of F1 lines generated}

\item{selfingGenerations}{The number of selfing generations at the end of the pedigree}

\item{nSeeds}{The number of progeny taken from each intercrossing line, or from each F1 if no intercrossing is specified. These lines are then selfed according to selfingGenerations}

\item{intercrossingGenerations}{The number of generations of intercrossing, after each F2 line is generated.}
}
\value{
An object of class \code{detailedPedigree} representing the experimental design, suitable for simulation using simulateMPCross.
}
\description{
Generate a four-parent pedigree starting from inbred founders, using a single funnel
}
\details{
Note that unlike \code{\link{fourParentPedigreeRandomFunnels}}, there is no intercrossing allowed in the single funnel case because the relevant haplotype probabilities assume randomly chosen funnels
}
\seealso{
\code{\link{fourParentPedigreeRandomFunnels}}, \code{\link{twoParentPedigree}}
}
