% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_functions.R
\name{last_date}
\alias{last_date}
\title{Extract the date of the last entry}
\usage{
last_date(db, sensor, participant_id = NULL)
}
\arguments{
\item{db}{A database connection to an m-Path Sense database.}

\item{sensor}{The name of a sensor. See \link[mpathsenser]{sensors} for a list of available
sensors.}

\item{participant_id}{A character string identifying a single participant. Use
\code{\link[mpathsenser]{get_participants}} to retrieve all participants from the database.
Leave empty to get data for all participants.}
}
\value{
A string in the format 'YYYY-mm-dd' of the last entry date.
}
\description{
A helper function for extracting the last date of entry of (of one or all participant) of one
sensor. Note that this function is specific to the last date of a sensor. After all, it
wouldn't make sense to extract the last date for a participant of the device info, while the
last accelerometer measurement occurred a day later.
}
\examples{
\dontrun{
db <- open_db()
first_date(db, 'Accelerometer', '12345')
}
}
