% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpcmp-package.R
\docType{data}
\name{cottonbolls}
\alias{cottonbolls}
\title{Cotton Bolls data set}
\format{
A data frame with 125 observations on 4 variables.
\describe{
\item{nc}{number of bolls produced by two cotton plants at harvest}
\item{stages}{growth stage}
\item{def}{artificial defoliation level}
\item{def2}{square of def}
}
}
\source{
Supplementary Content of Zeviani et al. (2014):
\url{http://www.leg.ufpr.br/doku.php/publications:papercompanions:zeviani-jas2014}
}
\usage{
data(cottonbolls)
}
\description{
This data set gives the observed number of bolls produced by the cotton
plants at five growth stages: vegetative, flower-bud, blossom, fig and cotton boll;
to examine the effect of five defoliation levels (0\\%, 25\\%, 50\\%, 75\\% and 100\\%).
}
\examples{
### Huang (2017) Page 373--375: Underdispersed Cotton bolls data
### Model fitting for predictor V 

data(cottonbolls)
M.bolls <- glm.cmp(nc~ 1+stages:def+stages:def2, data= cottonbolls)
M.bolls
summary(M.bolls)

}
\references{
Zeviani, W.M., Riberio P.J. Jr., Bonat, W.H., Shimakura S.E. and Muniz J.A. (2014).
The Gamma-count distribution in the analysis of experimental underdispersed data.
\emph{Journal of Applied Statistics} \bold{41}, 2616--26.
}
\keyword{datasets}
