% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chebyshev.R
\name{chebyshev}
\alias{chebyshev}
\title{Chebyshev polynomials}
\usage{
chebyshev(degree, kind = "t", indeterminate = "x", normalized = FALSE)
}
\arguments{
\item{degree}{degree of polynomial}

\item{kind}{"t" or "u" (Chebyshev polynomials of the first and
second kinds), or "c" or "s"}

\item{indeterminate}{indeterminate}

\item{normalized}{provide normalized coefficients}
}
\value{
a mpoly object or mpolyList object
}
\description{
Chebyshev polynomials as computed by orthopolynom.
}
\examples{

chebyshev(0)
chebyshev(1)
chebyshev(2)
chebyshev(3)
chebyshev(4)
chebyshev(5)
chebyshev(6)
chebyshev(10)

chebyshev(0:5) 
chebyshev(0:5, normalized = TRUE)
chebyshev(0:5, kind = "u")
chebyshev(0:5, kind = "c")
chebyshev(0:5, kind = "s")
chebyshev(0:5, indeterminate = "t")



# visualize the chebyshev polynomials

library(ggplot2); theme_set(theme_bw())
library(reshape2)

s <- seq(-1, 1, length.out = 201)
N <- 5 # number of chebyshev polynomials to plot
(chebPolys <- chebyshev(0:N))

df <- t(sapply(s, as.function(chebPolys)) )
df <- as.data.frame(cbind(s, df))
names(df) <- c("x", paste0("T_", 0:N))
mdf <- melt(df, id = "x")
qplot(x, value, data = mdf, geom = "line", color = variable)



}
\author{
David Kahle calling code from the orthopolynom package
}
\seealso{
\code{\link{chebyshev.t.polynomials}}, 
  \code{\link{chebyshev.u.polynomials}}, 
  \code{\link{chebyshev.c.polynomials}}, 
  \code{\link{chebyshev.s.polynomials}}, 
  \url{http://en.wikipedia.org/wiki/Chebyshev_polynomials}
}

