% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.mppData.R
\name{create.mppData}
\alias{create.mppData}
\title{Create a multi-parent population data object}
\usage{
create.mppData(geno.off = NULL, geno.par = NULL, map = NULL,
  pheno = NULL, cross.ind = NULL, par.per.cross = NULL)
}
\arguments{
\item{geno.off}{\code{Character} marker score \code{matrix} of the offspring
with genotypes as row and markers as column.
\strong{Rows names must be the offspring genotypes identifiers similar to
the one used in \code{pheno}. The columns names must be the marker names
similar to the one used in \code{map}. Marker scores must be coded using one
letter per allele. For example, AA, CC, GG, etc. Missing values must be coded
\code{NA}.}}

\item{geno.par}{\code{Character} marker score \code{matrix} of the parents
with genotypes as row and markers as column.
\strong{Rows names must be the parents genotypes identifiers similar to
the one used in \code{par.per.cross}. The columns names must be the marker
names similar to the one used in \code{map}. Marker scores must be coded
using one letter per allele. For example, AA, CC, GG, etc. Missing values
must be coded \code{NA}.}}

\item{map}{Three columns \code{data.frame} with: 1) \code{character} marker
identifiers; 2) \code{numeric} chromosome; 3) \code{numeric} positions in
centi-Morgan.\strong{The marker identifiers must be identical to the column
names of the maker matrices (\code{geno.off} and \code{geno.par}).}}

\item{pheno}{\code{Numeric matrix} with one column per trait and rownames
as genotypes identifiers. \strong{The genotypes identifiers must be identical
to the rownames of the offspring marker matrix (\code{geno.off}).}}

\item{cross.ind}{\code{Character} vector indicating to which cross each
genotype belongs.}

\item{par.per.cross}{Three columns \code{Character matrix} specifying :
1) the cross indicators; 2) the parents 1 identifiers
of the crosses; 3) the parents 2 identifiers of the crosses.
\strong{The list of crosses must contain the same cross indicators as in
\code{cross.ind} and they must appear in the same order.
The list of parent identifiers must be the same to the rownames of
the argument \code{geno.par}}.}
}
\value{
a \code{list} of class \code{mppData} which contains the following elements

\item{geno.off}{\code{Matrix} with offspring marker scores.}

\item{geno.par}{\code{Matrix} with parents marker scores.}

\item{pheno}{\code{Matrix} with phenotypic trait values.}

\item{map}{\code{Data.frame} with genetic marker information.}

\item{cross.ind}{Cross indicator.}

\item{par.per.cross}{\code{Character matrix} information about cross and
the parents of the crosses.}

The \code{list} also contain other arguments that will be filled later in
the data processing.
}
\description{
This function combines all raw data sources in a single data object of class
\code{mppData}.
}
\examples{

data(USNAM_geno)
data(USNAM_map)
data(USNAM_pheno)

geno.off <- USNAM_geno[7:506, ]
geno.par <- USNAM_geno[1:6, ]
map <- USNAM_map
pheno <-  USNAM_pheno
cross.ind <- substr(rownames(pheno), 1, 4)
par.per.cross <- cbind(unique(cross.ind), rep("B73", 5),
                       rownames(geno.par)[2:6])

mppData <- create.mppData(geno.off = geno.off, geno.par = geno.par,
                          map = map, pheno = pheno, cross.ind = cross.ind,
                          par.per.cross = par.per.cross)
                          
}
\author{
Vincent Garin
}
