% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parent_cluster.mppData.R
\name{parent_cluster.mppData}
\alias{parent_cluster.mppData}
\title{Parent clustering for \code{mppData} objects}
\usage{
parent_cluster.mppData(mppData, par.clu = NULL)
}
\arguments{
\item{mppData}{An object of class \code{mppData}. the \code{mppData} must
have been processed using: \code{\link{create.mppData}},
\code{\link{QC.mppData}}, \code{\link{IBS.mppData}},
and \code{\link{IBD.mppData}}.}

\item{par.clu}{\code{Interger matrix} representing the results of a
parents genotypes clustering. The columns represent the parental lines and
the rows the markers. The columns names must be the same as the parents
list of the mppData object. The rownames must be the same as the map marker
list of the mppData object. At a particular position, parents with the same
value are assumed to inherit from the same ancestor. for more details,
see \code{\link{par_clu}}. Default = NULL.}
}
\value{
An increased \code{mppData} object containing the the same elements
as the \code{mppData} object provided as argument and the
following new elements:

\item{par.clu}{\code{Integer matrix} with rows repersenting markers and
columns corresponding to the parents. At a single marker position, parents
with the same value were clustered in the same ancestral group.}

\item{n.anc}{Average number of ancestral clusters along the genome.}

\item{mono.anc}{Positions for which the ancestral clustering was monomorphic.}
}
\description{
Integrate the parent clustering information to the mppData
object. The parent clustering is necessary to compute the ancestral model.
If the parent clustering step is skipped, the ancestral model can not be
used but the other models (cross-specific, parental, and bi-allelic) can
still be computed.
}
\details{
At a single marker position, two parents can be grouped into a similar
ancestral classes if we assume that they receive there allele from a common
ancetor. The parent clustering information (\code{par.clu}) describe parental
relatedness and which parent belong to which ancestral group. For example,
at marker i, we could have five parents (pA, pB, pC, pD, pE) and the following
clustering information (1, 2, 1, 2, 3). This means that pA and pC received
their allele from the same ancetor (A1). pB and pD also have a shared
ancestor (A2) who is different from (A1). And pE was not included in any
group and can be seen as an indepedent ancestral group (A3).

The parent clustering information is provided via \code{par.clu}. It is an
\code{interger matrix} with markers in row and parents in columns.
At a particular marker position, parents with the same value are assumed to
inherit from the same ancestor. for more details, see \code{\link{par_clu}}.

The parent clustering can be performed using the R package
'clusthaplo' that can be found there:
\url{https://cran.r-project.org/src/contrib/Archive/clusthaplo/}.
The 'clusthaplo' option is not integrated in this version of mppR. However,
a version of mppR with function calling clusthaplo can be found on github
\url{https://github.com/vincentgarin/mppR} (branch mppR_clusthaplo).
}
\examples{

data(mppData_init)
data(par_clu)

mppData <- QC.mppData(mppData_init)
mppData <- IBS.mppData(mppData = mppData)

mppData <- IBD.mppData(mppData = mppData, type = 'RIL',
                       type.mating = 'selfing')
                       
mppData <- parent_cluster.mppData(mppData = mppData, par.clu  = par_clu)                         
                       

}
\seealso{
\code{\link{create.mppData}}, \code{\link{QC.mppData}},
\code{\link{IBS.mppData}}, \code{\link{IBD.mppData}}, \code{\link{par_clu}}
}
\author{
Vincent Garin
}
