% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_gaz_search.R
\name{gaz_rest_record_by_mrgid}
\alias{gaz_rest_record_by_mrgid}
\title{Get one record for the given MRGID}
\usage{
gaz_rest_record_by_mrgid(mrgid, with_geometry = FALSE, rdf = FALSE)
}
\arguments{
\item{mrgid}{(integer) A valid Marine Regions Gazetteer Identifier (\link{MRGID})}

\item{with_geometry}{(logical) Add geometry to the result data frame? Default = FALSE}

\item{rdf}{(logical) Return an object of class \link[rdflib:rdf]{rdflib::rdf}?}
}
\value{
A data frame with the Gazetteer entry
}
\description{
Get one record for the given MRGID
}
\examples{
\donttest{
gaz_rest_record_by_mrgid(3293)
gaz_rest_record_by_mrgid(3293, with_geometry = TRUE)
gaz_rest_record_by_mrgid(3293, rdf = TRUE)
}
}
\seealso{
\link{gaz_rest}, \link{MRGID}
}
