% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_set.R
\name{expand_observations}
\alias{expand_observations}
\title{Insert observations into a data set}
\usage{
expand_observations(data, times, unique = FALSE)
}
\arguments{
\item{data}{a data set or event object}

\item{times}{a vector of observation times}

\item{unique}{`logical`; if `TRUE` then values for `time` are 
dropped if they are found anywhere in `data`}
}
\value{
A data frame
}
\description{
Insert observations into a data set
}
\details{
Non-numeric columns will be dropped with a warning.
}
\examples{
data <- expand.ev(amt = c(100,200,300))

expand_observations(data, times = seq(0,48,2))

}
