% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conn.R
\name{msgConnection}
\alias{msgConnection}
\alias{close.msgConnection}
\alias{partial}
\alias{partial.msgConnection}
\alias{readMsgs}
\alias{status}
\alias{status.msgConnection}
\alias{seek.msgConnection}
\alias{readMsg}
\alias{writeMsg}
\alias{writeMsgs}
\title{Read and write msgpack formatted messages over R connections.}
\usage{
msgConnection(con, read_size = 2^16, max_size = NA, ...)

\method{close}{msgConnection}(con, ...)

partial(con)

\method{partial}{msgConnection}(con)

readMsgs(con, n = NA, ...)

status(con)

\method{status}{msgConnection}(con)

\method{seek}{msgConnection}(con, rw = summary(con)$mode, ...)

readMsg(con, ...)

writeMsg(obj, con, ...)

writeMsgs(objs, con, ...)
}
\arguments{
\item{con}{A \link{connection} object open in binary mode.}

\item{read_size}{How many bytes to read at a time.}

\item{max_size}{The largest partial message to store, in
bytes. \code{NA} means do not enforce a limit.}

\item{...}{Unpacking options (see \link{unpackMsg}).}

\item{n}{The maximum number of messages to read. A value of NA
means to parse all available messages until end of input.}

\item{rw}{See \code{\link[=seek]{seek()}}.}

\item{obj}{An R object.}

\item{objs}{A list of R objects.}
}
\value{
\code{msgConnection()} returns an object of class
\code{msgConnection}.

\code{partial(con)} returns any data that has been read ahead of
the last decoded message.

\code{readMsgs(con, n)} returns a list of up to \code{n} decoded messages.

\code{status(con)} returns the status of msgpack decoding on the
connection. A value of \code{"ok"} indicates all requested messages
were read, \code{"buffer underflow"} for a non-blocking connection
indicates that only part of a message has been received, and
\code{"end of input"} means the last available message has been read.
Other values indicate errors encountered in decoding, which will
effectively halt reading.

\code{seek(con)} returns the number of bytes that have been
successfully read or written, depending on the mode of the
connection. (Repositioning is not supported.)

\code{readMsg(con)} returns one decoded message.
}
\description{
A \code{msgConnection} object decodes msgpack messages from an
underlying R raw connection.

\code{readMsg(con)} reads exactly one message from a
msgConnection, or throws an error.

\code{writeMsg(x, con)} writes a single message to a msgConnection.

\code{writeMsg} will work with any R connection in raw mode, but reading
requires a msgConnection object.
}
\details{
Because msgpack messages have unpredictable length, the decoder
reads ahead in chunks, then finds the boundaries between messages.
Therefore when reading over a socket or a fifo it is best to use a
nonblocking connection, and it will not work to mix readMsg and
readBin on the same connection.

If you are reading data from a not completely trusted source you
should specify options \code{max_size} and \code{max_depth} (see
\link{unpackOpts}). Without it, some deeply nested or cleverly designed
messages can cause a stack overflow or out-of-memory error.  With
these options set, you will get an R exception instead.
}
\examples{
out <- rawConnection(raw(0), open="wb")
apply(quakes, 1, function(x) writeMsg(x, out))
length(rawConnectionValue(out))
inn <- msgConnection(rawConnection(rawConnectionValue(out), open="rb"))
readMsg(inn)
readMsgs(inn, 3)
}
