% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{cvmsma}
\alias{cvmsma}
\title{Cross-Validation}
\usage{
cvmsma(X, Y = NULL, Z = NULL, comp = 1, lambdaX, lambdaY = NULL,
  eta = 1, type = "lasso", inX = NULL, inY = NULL, muX = 0, muY = 0,
  nfold = 5, seed = 1)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s) which is required.}

\item{Y}{a (list of) matrix, objective variable(s). This is optional. If no input for Y, then the PCA method is implemented.}

\item{Z}{a vector, response variable(s). This is optional. The length is the number of subjects. If no input for Z, then the unsupervised PLS/PCA is implemented.}

\item{comp}{numeric scalar for the number of components to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar, the parameter indexing the penalty family. This version has only the choice 1.}

\item{type}{a character, the penalty family. This version has only the choice "lasso".}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised. 0<=muX<=1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised. 0<=muY<=1.}

\item{nfold}{number of folds - default is 5.}

\item{seed}{number of seed for the random number.}
}
\value{
\item{err}{The mean cross-validated errors which has three elements consisting of the mean of errors for X and Y, the errors for X and for Y in the PLS and only the errors for X in the PCA.}
}
\description{
cross-validated method to evaluate the fit of msma.
}
\details{
k-fold cross-validation for \code{msma}. The evaluation is based on the matrix element wise errors.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component CV #####
cv1 = cvmsma(X, Y, comp = 1, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv1

##### Two Component CV #####
cv2 = cvmsma(X, Y, comp = 2, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv2

}

