% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microstrategy.R
\docType{methods}
\name{close}
\alias{close}
\alias{close,connection-method}
\title{Closes a connection with MicroStrategy REST API}
\usage{
close(connection)

\S4method{close}{connection}(connection)
}
\arguments{
\item{connection}{MicroStrategy REST API connection object returned by \code{connect_mstr()}}
}
\description{
Closes a connection with MicroStrategy REST API.
}
\examples{
\donttest{
# Connect to a MicroStrategy environment
con <- connect_mstr(base_url = "https://demo.microstrategy.com/MicroStrategyLibrary/api",
                    username = "user",
                    password = "password",
                    project_name = "Financial Reporting")

# A good practice is to disconnect once you're done
# However, the server will disconnect the session after some time has passed
close(con)
}
}
