% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviceXML.R
\name{parse_devicexml_for_a_device}
\alias{parse_devicexml_for_a_device}
\title{Parse XML file for given device name}
\usage{
parse_devicexml_for_a_device(file_path_xml, device_name,
  mtconnect_version = NULL)
}
\arguments{
\item{file_path_xml}{File path of the XML file}

\item{device_name}{Name of the device to be searched in the XML}

\item{mtconnect_version}{Version number of mtconnect standard}
}
\description{
Get all the info on a particular device present in the XML
Returns a list of parsed_xml,device_details and mtconnect_version
}
\examples{
file_path_xml   = "testdata/dataExtraction/test_devices.xml"
device_name = "test_device"
parsed_device_xml = parse_devicexml_for_a_device(system.file(file_path_xml,
                                                package = "mtconnectR"),device_name)
}
