% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename.values}
\alias{rename.values}
\title{Replace/rename values in a vector}
\usage{
rename.values(x, ..., defaultValue = x, warn_missing = TRUE)
}
\arguments{
\item{x}{Vector of values to replace}

\item{...}{Key/value pairs in the form \code{oldvalue="newvalue"}}

\item{defaultValue}{A vector of values to use as the default should the value not
be found in \code{...}}

\item{warn_missing}{Print a message if any old names are not actually present in x}
}
\value{
A vector with values replaced
}
\description{
This function replaces character values with new character values, which
is useful when performing rename operations when values are held in character vectors.
}
\examples{
x <- c("fish", "fish", "fish", "whistle")
rename.values(x, fish="newfish")
rename.values(x, whistle="newwhistle")
rename.values(x, fish="newfish", defaultValue="not a fish")

}

