% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{hierfly}
\alias{hierfly}
\title{Generate a dendrogram to be added to data}
\usage{
hierfly(data, h = NULL, metric = "euclidean", method = "ward.D2", scale = TRUE)
}
\arguments{
\item{data}{data set}

\item{h}{an hclust object}

\item{metric}{distance metric to use, see \code{\link{dist}} for list of
possibilities}

\item{method}{cluster distance measure to use, see \code{\link{hclust}} for
details}

\item{scale}{logical value whether to scale data or not, default TRUE}
}
\value{
list with data and edges and segments
}
\description{
Supplements a data set with information needed to draw a
dendrogram. Intermediate cluster nodes are added as needed, and
positioned at the centroid of the combined clusters. Note that
categorical variables need to be factors.
}
\examples{
data(clusters)
cl_dist <- dist(clusters[,1:5])
cl_hw <- hclust(cl_dist, method="ward.D2")
require(ggdendro)
ggdendrogram(cl_hw, type = "triangle", labels = FALSE)
clusters$clw <- factor(cutree(cl_hw, 3))
cl_hfly <- hierfly(clusters, cl_hw, scale=FALSE)
if (interactive()) {
  require(tourr)
  glyphs <- c(16, 46)
  pch <- glyphs[cl_hfly$data$node+1]
  require(colorspace)
  clrs <- heat_hcl(length(unique(cl_hfly$data$clw)))
  pcol <- clrs[cl_hfly$data$clw]
  ecol <- clrs[cl_hfly$data$clw[cl_hfly$edges[,1]]]
  animate_xy(cl_hfly$data[,1:5], edges=cl_hfly$edges,
    col=pcol, pch=pch, edges.col=ecol,
    axes="bottomleft")
}
}
\keyword{cluster}
