% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiCA.R
\name{cnonct}
\alias{cnonct}
\title{Non-centrality parameter for chi-square distribution}
\usage{
cnonct(x, p, df)
}
\arguments{
\item{x}{a numeric value at which the distribution was evaluated}

\item{p}{a numeric value giving the cumulative probability at \code{x}}

\item{df}{an integer giving the degrees of freedom of the chi-square variable}
}
\description{
Calculates the non-centrality parameter for a chi-square distribution for a given 
quantile. This is often needed for sample size calculation for chi-square based tests.
}
\details{
The function is modeled after the SAS function CNONCT. If \code{p} is larger 
than the cumulative probability of the central chi-square distribution at \code{x}, then
there is no solution and NA is returned.
}
\examples{
(ncp <- cnonct(qchisq(0.95, df=10), 0.8, df=10))
## check
pchisq(qchisq(0.95, df=10), df=10, ncp=ncp)  ## 0.8
}

