% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{potato}
\alias{potato}
\title{Sensory, rheological, chemical and spectroscopic analysis of potatoes.}
\format{
A data.frame having 26 rows and 9 variables:
\describe{
\item{Chemical}{Matrix of chemical measurements}
\item{Compression}{Matrix of rheological compression data}
\item{NIRraw}{Matrix of near-infrared measurements of raw potatoes}
\item{NIRcooked}{Matrix of near-infrared measurements of cooked potatoes}
\item{CPMGraw}{Matrix of NMR (CPMG) measurements of raw potatoes}
\item{CPMGcooked}{Matrix of NMR (CPMG) measurements of cooked potatoes}
\item{FIDraw}{Matrix of NMR (FID) measurements of raw potatoes}
\item{FIDcooked}{Matrix of NMR (FID) measurements of cooked potatoes}
\item{Sensory}{Matrix of sensory assessments}
}
}
\usage{
data(potato)
}
\description{
A dataset containing 9 blocks of measurements on 26 potatoes.
Original dataset can be found at http://models.life.ku.dk/Texture_Potatoes.
This version has been pre-processed as follows (corresponding to Liland et al. 2016):
\itemize{
\item Variables containing NaN have been removed.
\item Chemical and Compression blocks have been scaled by standard deviations.
\item NIR blocks have been subjected to SNV (Standard Normal Variate).
}
}
\references{
\itemize{
\item L.G.Thygesen, A.K.Thybo, S.B.Engelsen, Prediction of Sensory Texture Quality of Boiled Potatoes
From Low-field1H NMR of Raw Potatoes. The Role of Chemical Constituents. LWT - Food Science and Technology 34(7), 2001, pp 469-477.
\item Kristian Hovde Liland, Tormod Næs, Ulf Geir Indahl, ROSA – a fast extension of Partial Least Squares Regression for Multiblock Data Analysis,
Journal of Chemometrics 30:11 (2016), pp. 651-662.
}
}
