% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvv_manual.R
\name{cvv_manual}
\alias{cvv_manual}
\title{Coefficient of variance variation from manual input sample sizes and variance estimates}
\usage{
cvv_manual(sample_sizes, variances)
}
\arguments{
\item{sample_sizes}{Numeric vector of length > 1. Sample sizes used for each variance estimate.}

\item{variances}{Numeric vector of length > 1. Variance estimates.}
}
\value{
A vector including VR, CVV, and SVH.
}
\description{
Calculates three different indices for variation between two or more variance estimates.
VR = Variance ratio between the largest and the smallest variance.
CVV = Coefficient of variance variation (Box, 1954).
SVH = Standardized variance heterogeneity (Ruscio & Roche, 2012).
}
\examples{
cvv_manual(sample_sizes=c(10,100,1000,75,3),
variances=c(1.5,2,2.5,3,3.5))
}
\references{
Box, G. E. P. (1954). Some Theorems on Quadratic Forms Applied in the Study of Analysis of Variance Problems, I. Effect of Inequality of Variance in the One-Way Classification. The Annals of Mathematical Statistics, 25(2), 290–302.

Ruscio, J., & Roche, B. (2012). Variance Heterogeneity in Published Psychological Research: A Review and a New Index. Methodology, 8(1), 1–11. https://doi.org/10.1027/1614-2241/a000034
}
