% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsumk.R
\name{nsumk}
\alias{nsumk}
\title{Ordered \emph{n}-tuples of non-negative integers summing to \emph{k}}
\usage{
nsumk(n, k)
}
\arguments{
\item{n}{a positive integer.}

\item{k}{a positive integer.}
}
\value{
A matrix with \code{choose(k+n-1,n-1)} rows and \code{n} columns.
Each row comprises non-negative integers summing to \code{k}.
}
\description{
Finds ordered \emph{n}-tuples of non-integers summing to \emph{k}.
Only practical for \emph{n} < 15.
}
\details{
Useful for finding all possible degree sequences for a network with \code{n} nodes
and \code{k}/2 number of edges, or for finding all possible
edge multiplicity sequence \code{n} that sum up to \emph{k} number of edges.
The number of vertex pair sites (or length of edge multiplicity sequence) for
a multigraph with \emph{n} nodes is given by \eqn{n(n+1)/2}.
}
\examples{
# All possible degree sequences for
# a network with 4 nodes and 5 edges
D <- nsumk(4, 10)

# Remove degree sequences with isolated nodes
D <- D[-which(rowSums(D == 0) > 0), ]

# All edge multiplicity sequences/multigraph with 2 nodes and 4 edges
r <- (2*3)/2 # vertex pair sites (or length of edge multiplicity sequences)
mg <- nsumk(r,4) # number of rows give number of possible multigraphs
}
\seealso{
\code{\link{gof_sim}}
}
\author{
Termeh Shafie
}
