% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevelGPSStratification.R
\name{multilevelGPSStratification}
\alias{multilevelGPSStratification}
\title{Stratification on GPS with multilevel treatments}
\usage{
multilevelGPSStratification(Y, W, X, NS, GPSM = "multinomiallogisticReg",
  linearp = 0, nboot)
}
\arguments{
\item{Y}{A continuous response vector (1 x n)}

\item{W}{A treatment vector (1 x n) with numerical values indicating
treatment groups}

\item{X}{A covariate matrix (p x n) with no intercept}

\item{NS}{The number of strata: (only required in the function
\code{\link{multilevelGPSStratification}})}

\item{GPSM}{An indicator of the methods used for estimating GPS, options
include "multinomiallogisticReg", "ordinallogisticReg", and "existing"}

\item{linearp}{An indicator of subclassification on GPS (=0) or linear
predictor of GPS (=1): (only required in the function
\code{\link{multilevelGPSStratification}})}

\item{nboot}{The number of boot replicates for variance estimation: (only
required in the function \code{\link{multilevelGPSStratification}})}
}
\value{
A list with two elements,
  \code{tauestimate}, \code{varestimate}, where \code{tauestimate} is a
  vector of estimates for pairwise treatment effects, and \code{varestimate}
  is a vector of variance estimates, using bootstrapping method.
}
\description{
Stratification on GPS with multilevel treatments
}
\examples{

simulated_data <- multilevelMatching::simulated_data
set.seed(123)
multilevelGPSStratification(
  Y = simulated_data$outcome ,
  W = simulated_data$treatment,
  X = simulated_data[ ,names(simulated_data) \%in\% paste0("covar", 1:6)],
  GPSM = "multinomiallogisticReg",
  NS = 5,
  linearp = TRUE,
  nboot = 10
)

}
\references{
Yang, S., Imbens G. W., Cui, Z., Faries, D. E., & Kadziola, Z.
  (2016) Propensity Score Matching and Subclassification in Observational
  Studies with Multi-Level Treatments. Biometrics, 72, 1055-1065.
  \url{https://doi.org/10.1111/biom.12505}

  Abadie, A., & Imbens, G. W. (2006). Large sample properties of matching
  estimators for average treatment effects. Econometrica, 74(1), 235-267.
  \url{https://doi.org/10.1111/j.1468-0262.2006.00655.x}

  Abadie, A., & Imbens, G. W. (2016). Matching on the estimated propensity
  score. Econometrica, 84(2), 781-807.
  \url{https://doi.org/10.3982/ECTA11293}
}
\seealso{
\code{\link{multilevelGPSMatch}}; \code{\link{multilevelMatchX}}
}
