% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{modelDiagnostics.merMod}
\alias{modelDiagnostics.merMod}
\title{modelDiagnostics method for merMod objects}
\usage{
\method{modelDiagnostics}{merMod}(
  object,
  ev.perc = 0.001,
  robust = FALSE,
  distr = "normal",
  standardized = TRUE,
  ...
)
}
\arguments{
\item{object}{A fitted model object, either of class merMod from
the lme4 package or merModLmerTest from the lmerTest package.}

\item{ev.perc}{A real number between 0 and 1 indicating the
proportion of the theoretical distribution beyond which
values are considered extreme values (possible outliers).
Defaults to .001.}

\item{robust}{Whether to use robust mean and standard deviation estimates
for normal distribution}

\item{distr}{A character string given the assumed distribution.
Passed on to \code{\link{testDistribution}}.
Defaults to \dQuote{normal}.}

\item{standardized}{A logical whether to use standardized residuals.
Defaults to \code{TRUE} generally where possible but may depend on
method.}

\item{...}{Additional arguments, not currently used.}
}
\value{
A logical (\code{is.modelDiagnostics}) or
  a modelDiagnostics object (list) for
  \code{as.modelDiagnostics} and \code{modelDiagnostics}.
}
\description{
This function creates a number of diagnostics
for \code{merMod} models.
}
\examples{

library(JWileymisc)
sleep[1,1] <- NA
m <- lme4::lmer(extra ~ group + (1 | ID), data = sleep)

md <- modelDiagnostics(m, ev.perc = .1)
md$extremeValues
class(md)

plot(md)

data(aces_daily, package = "JWileymisc")
m <- lme4::lmer(PosAff ~ STRESS + (1 + STRESS | UserID), data = aces_daily)
md <- modelDiagnostics(m, ev.perc = .1)

#  gm1 <- lme4::glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
#    data = lme4::cbpp, family = binomial)
# modelDiagnostics(gm1) ## should be an error

rm(m, md, sleep)
}
\keyword{plot}
