% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{fitted.brmcoda}
\alias{fitted.brmcoda}
\alias{fitted}
\title{Expected Values of the Posterior Predictive Distribution}
\usage{
\method{fitted}{brmcoda}(object, acomp = FALSE, summary = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{brmcoda}.}

\item{acomp}{Should the
results be returned on the compositional scale of the response variable?
Only applicable for models with compositional response}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{fitted.brmsfit}}
that control additional aspects of prediction.}
}
\value{
An \code{array} of predicted \emph{mean} response values.
  If \code{summary = FALSE} the output resembles those of
  \code{\link[brms]{posterior_epred.brmsfit}}.

  If \code{summary = TRUE} the output depends on the family: For categorical
  and ordinal families, the output is an N x E x C array, where N is the
  number of observations, E is the number of summary statistics, and C is the
  number of categories. For all other families, the output is an N x E
  matrix. The number of summary statistics E is equal to \code{2 +
  length(probs)}: The \code{Estimate} column contains point estimates (either
  mean or median depending on argument \code{robust}), while the
  \code{Est.Error} column contains uncertainty estimates (either standard
  deviation or median absolute deviation depending on argument
  \code{robust}). The remaining columns starting with \code{Q} contain
  quantile estimates as specified via argument \code{probs}.

  In multivariate models, an additional dimension is added to the output
  which indexes along the different response variables.
}
\description{
Compute posterior draws of the expected value of the posterior predictive
distribution of a \code{brmsfit} model in the \code{brmcoda} object.
Can be performed for the data used to fit the model (posterior
predictive checks) or for new data. By definition, these predictions have
smaller variance than the posterior predictions performed by the
\code{\link{predict.brmcoda}} method. This is because only the
uncertainty in the expected value of the posterior predictive distribution is
incorporated in the draws computed by \code{fitted} while the
residual error is ignored there. However, the estimated means of both methods
averaged across draws should be very similar.
}
\examples{
\donttest{
## fit a model
if(requireNamespace("cmdstanr")){
  ## compute composition and ilr coordinates
  cilr <- compilr(data = mcompd, sbp = sbp,
                  parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                  idvar = "ID", total = 1440)
  
  ## fit a model
  m1 <- brmcoda(compilr = cilr,
                formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
                  wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  ## compute expected predictions
  epred <- fitted(m1)
  head(epred)
  
  ## fit a model with compositional outcome
  m2 <- brmcoda(compilr = cilr,
                formula = mvbind(ilr1, ilr2, ilr3, ilr4) ~ Stress + Female + (1 | ID),
                chain = 1, iter = 500,
                backend = "cmdstanr")
  
  ## expected predictions on compositional scale
  epredcomp <- fitted(m2, acomp = TRUE)
  head(epredcomp)
}}
}
\seealso{
\code{\link[brms:fitted.brmsfit]{fitted.brmsfit}}
}
