% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build.basesub}
\alias{build.basesub}
\title{Build Base Pairwise Substitution}
\usage{
build.basesub(parts, comparison = NULL)
}
\arguments{
\item{parts}{A character vector specifying the names of compositional variables to be used.}

\item{comparison}{Either \code{"one-to-one"} or \code{"one-to-all"}. Default is \code{"one-to-one"}.}
}
\value{
A data table of all possible pairwise substitution.
}
\description{
Make a data set of all possible pairwise substitution of a composition which can be used as
the base for substitution models.
}
\examples{
ps1 <- build.basesub(parts = c("TST", "WAKE", "MVPA", "LPA", "SB"))
print(ps1)

ps2 <- build.basesub(c("WAKE", "MVPA", "LPA", "SB"), comparison = "one-to-all")
print(ps2)
}
