% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare-data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare our claims data for analysis}
\usage{
prepare_data(
  dat = NULL,
  style = "long",
  id = NULL,
  prefix_dx = "dx",
  hcpcs = "no",
  prefix_hcpcs,
  version_var,
  type_name,
  date
)
}
\arguments{
\item{dat}{dataset}

\item{style}{long, the default, is one diagnosis column per row whereas wide is multiple diagnosis columns}

\item{id}{unique patient identifier variable name}

\item{prefix_dx}{the variable prefix for the diagnosis columns (defaults to "dx"), in quotes}

\item{hcpcs}{whether or not HCPCS variables are included ("yes" or "no", where "no" is the default)}

\item{prefix_hcpcs}{if HCPCS are included, the variable prefix in quotes}

\item{version_var}{variable which denotes if the diagnoses on that row are ICD-9 (9) or ICD-10 (10)}

\item{type_name}{variable to denote if the claim is inpatient (ip) or outpatient (ot)}

\item{date}{variable with the date of the claim}
}
\value{
dataframe with multiple rows per patient, which has re-structured their claims
}
\description{
\code{prepare_data} returns a dataset which has been transformed and prepared for subsequent functions in this
package.
}
\details{
This function takes our raw claims data, in a number of different forms, and prepares it in a way which allows the
other functions in this package to easily work with it. It is recommended to run this package on all data
regardless of setup.
}
\examples{
prepare_data(dat = i9_i10_comb, id = patient_id, style = "wide",
prefix_dx = "dx", hcpcs = "yes", prefix_hcpcs = "hcpcs", version_var = icd_version,
type_name = visit_type, date = date_of_serv)

}
