% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_data.R
\name{set_ipd}
\alias{set_ipd}
\title{Set up individual patient data}
\usage{
set_ipd(
  data,
  study,
  trt,
  y = NULL,
  r = NULL,
  E = NULL,
  trt_ref = NULL,
  trt_class = NULL
)
}
\arguments{
\item{data}{a data frame}

\item{study}{column of \code{data} specifying the studies, coded using integers,
strings, or factors}

\item{trt}{column of \code{data} specifying treatments, coded using integers,
strings, or factors}

\item{y}{column of \code{data} specifying a continuous outcome}

\item{r}{column of \code{data} specifying a binary outcome or Poisson outcome count}

\item{E}{column of \code{data} specifying the total time at risk for Poisson
outcomes}

\item{trt_ref}{reference treatment for the network, as a single integer,
string, or factor. If not specified, a reasonable well-connected default
will be chosen (see details).}

\item{trt_class}{column of \code{data} specifying treatment classes, coded using
integers, strings, or factors. By default, no classes are specified.}
}
\value{
An object of class \link{nma_data}
}
\description{
Set up a network containing individual patient data (IPD). Multiple data
sources may be combined once created using \code{\link[=combine_network]{combine_network()}}.
}
\details{
By default, \code{trt_ref = NULL} and a network reference treatment will be chosen
that attempts to maximise computational efficiency and stability. If an
alternative reference treatment is chosen and the model runs slowly or has
low effective sample size (ESS) this may be the cause - try letting the
default reference treatment be used instead. Regardless of which treatment is
used as the network reference at the model fitting stage, results can be
transformed afterwards: see the \code{trt_ref} argument of
\code{\link[=relative_effects]{relative_effects()}} and \code{\link[=predict.stan_nma]{predict.stan_nma()}}.
}
\examples{
# Set up network of plaque psoriasis IPD
head(plaque_psoriasis_ipd)

pso_net <- set_ipd(plaque_psoriasis_ipd,
                   study = studyc,
                   trt = trtc,
                   r = pasi75)

# Print network details
pso_net

# Plot network
plot(pso_net)

# Setting a different reference treatment
set_ipd(plaque_psoriasis_ipd,
        study = studyc,
        trt = trtc,
        r = pasi75,
        trt_ref = "PBO")
}
\seealso{
\code{\link[=set_agd_arm]{set_agd_arm()}} for arm-based aggregate data, \code{\link[=set_agd_contrast]{set_agd_contrast()}}
for contrast-based aggregate data, and \code{\link[=combine_network]{combine_network()}} for combining
several data sources in one network.

\code{\link[=print.nma_data]{print.nma_data()}} for the print method displaying details of the
network, and \code{\link[=plot.nma_data]{plot.nma_data()}} for network plots.
}
