% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.R
\name{ppp_binom}
\alias{ppp_binom}
\alias{ppp_multinom}
\title{Posterior Predictive p-Values}
\usage{
ppp_binom(prob, k, n, by)

ppp_multinom(prob, k, options, drop_fixed = TRUE)
}
\arguments{
\item{prob}{vector with probabilities or a matrix with one probability vector per row.
For \code{rpbinom}: probabilities of a success for each option.
For \code{rpmultinom}: probabilities of all categories excluding
the last category for each option (cf. \code{drop_fixed}).
See also \code{\link{sampling_binom}} and \code{\link{sampling_multinom}}.}

\item{k}{vector of observed response frequencies.}

\item{n}{integer vector, specifying the number of trials for each binomial/multinomial distribution
Note that this is the \code{size} argument in \code{rmultinom}, cf. \code{\link[stats]{Multinom}}.}

\item{by}{optional: a vector of the same length as \code{k} indicating factor levels
by which the posterior-predictive checks should be split (e.g., by item sets).}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{drop_fixed}{whether the output matrix includes the last probability for each category
(which is not a free parameter since probabilities must sum to one).}
}
\description{
Uses posterior samples to get posterior-predicted frequencies and compare
the Pearson's X^2 statistic for (1) the observed frequencies vs. (2) the
posterior-predicted frequencies.
}
\examples{
# uniform samples:  p<.10
prob <- matrix(runif(300*3, 0, .1), 300)
n <- rep(10, 3)
ppp_binom(prob, c(1,2,0), n)  # ok
ppp_binom(prob, c(5,4,3), n)  # misfit

# multinomial (ternary choice)
prob <- matrix(runif(300*2, 0, .05), 300)
ppp_multinom(prob, c(1,0,9), 3)  # ok
}
\references{
Myung, J. I., Karabatsos, G., & Iverson, G. J. (2005). A Bayesian approach to testing decision making axioms. \emph{Journal of Mathematical Psychology, 49}, 205-225. \url{https://doi.org/10.1016/j.jmp.2005.02.004}
}
\seealso{
\code{\link{sampling_binom}}/\code{\link{sampling_multinom}} to get
    posterior samples and \code{\link{rpbinom}}/\code{\link{rpmultinom}} to
    get posterior-predictive samples.
}
